/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.wood.block;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;

public class QuarterLogBlock
extends RotatedPillarBlock {
    public static final EnumProperty<BarkSide> BARK_SIDE = EnumProperty.m_61587_((String)"bark_side", BarkSide.class);

    public QuarterLogBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_(BARK_SIDE, (Comparable)((Object)BarkSide.NORTHEAST)));
    }

    @Deprecated(forRemoval=true, since="6.1.0")
    public QuarterLogBlock(Supplier<Block> stripped, MapColor color, BlockBehaviour.Properties settings) {
        this(settings);
        if (stripped != null) {
            StrippableBlockRegistry.register((Block)this, (Block)stripped.get());
        }
    }

    public static QuarterLogBlock of(MapColor color) {
        return new QuarterLogBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    public static QuarterLogBlock of(MapColor wood, MapColor bark) {
        return new QuarterLogBlock(BlockBehaviour.Properties.m_284310_().m_284495_(state -> switch ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Y -> wood;
            case Direction.Axis.X -> {
                switch ((BarkSide)((Object)((Object)state.m_61143_(BARK_SIDE)))) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTHWEST: 
                    case SOUTHWEST: {
                        yield bark;
                    }
                    case NORTHEAST: 
                    case SOUTHEAST: 
                }
                yield wood;
            }
            case Direction.Axis.Z -> {
                switch ((BarkSide)((Object)((Object)state.m_61143_(BARK_SIDE)))) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SOUTHWEST: 
                    case SOUTHEAST: {
                        yield bark;
                    }
                    case NORTHWEST: 
                    case NORTHEAST: 
                }
                yield wood;
            }
        }).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    public static QuarterLogBlock ofNether(MapColor color) {
        return new QuarterLogBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60978_(2.0f).m_60918_(SoundType.f_244244_));
    }

    public static QuarterLogBlock ofNether(MapColor wood, MapColor bark) {
        return new QuarterLogBlock(BlockBehaviour.Properties.m_284310_().m_284495_(state -> switch ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Y -> wood;
            case Direction.Axis.X -> {
                switch ((BarkSide)((Object)((Object)state.m_61143_(BARK_SIDE)))) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NORTHWEST: 
                    case SOUTHWEST: {
                        yield bark;
                    }
                    case NORTHEAST: 
                    case SOUTHEAST: 
                }
                yield wood;
            }
            case Direction.Axis.Z -> {
                switch ((BarkSide)((Object)((Object)state.m_61143_(BARK_SIDE)))) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SOUTHWEST: 
                    case SOUTHEAST: {
                        yield bark;
                    }
                    case NORTHWEST: 
                    case NORTHEAST: 
                }
                yield wood;
            }
        }).m_60978_(2.0f).m_60918_(SoundType.f_244244_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BARK_SIDE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 pos = context.m_43720_();
        BlockPos blockPos = context.m_8083_();
        float hitX = (float)(pos.m_7096_() - (double)blockPos.m_123341_());
        float hitY = (float)(pos.m_7098_() - (double)blockPos.m_123342_());
        float hitZ = (float)(pos.m_7094_() - (double)blockPos.m_123343_());
        BarkSide side = BarkSide.fromHit(context.m_43719_().m_122434_(), hitX, hitY, hitZ);
        return (BlockState)super.m_5573_(context).m_61124_(BARK_SIDE, (Comparable)((Object)side));
    }

    public static enum BarkSide implements StringRepresentable
    {
        SOUTHWEST("southwest"),
        NORTHWEST("northwest"),
        NORTHEAST("northeast"),
        SOUTHEAST("southeast");

        final String name;

        private BarkSide(String name) {
            this.name = name;
        }

        public static BarkSide fromHit(Direction.Axis axis, float hitX, float hitY, float hitZ) {
            boolean hitEast;
            return BarkSide.fromHalves(!hitEast, !(switch (axis) {
                case Direction.Axis.Y -> {
                    hitEast = (double)hitX >= 0.5;
                    yield (double)hitZ >= 0.5;
                }
                case Direction.Axis.X -> {
                    hitEast = (double)hitY <= 0.5;
                    yield (double)hitZ >= 0.5;
                }
                default -> {
                    hitEast = (double)hitX >= 0.5;
                    yield (double)hitY >= 0.5;
                }
            }));
        }

        public static BarkSide fromHalves(boolean east, boolean south) {
            if (east) {
                if (south) {
                    return SOUTHEAST;
                }
                return NORTHEAST;
            }
            if (south) {
                return SOUTHWEST;
            }
            return NORTHWEST;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

